use "${tmp}/exposure_main_file", clear
	
	forvalues year = 2004/2019 {
		gen  E_`year' = ln(1+exposure) * (year == `year')	
		gen  EP1_`year' = ln(1+exposure_pred)* (year == `year')
		gen  EP2_`year' = ln(1+exposure_pred_ref)* (year == `year')
		
		forvalues i = 1/5 {
			gen EPHerf`i'_`year' = ln(1+exposure_Herf`i'*(year == `year'))
		}

		gen EP3_`year' = ln(1+exposure_grade)*(year == `year')
	}

	drop E_${NORMYEAR}   EP*_${NORMYEAR}

	gen E_post11 = ln(1+exposure) * (year >= 2011)

	gen EP1_post11 = ln(1+exposure_pred) * (year >= 2011)
	gen EP2_post11 = ln(1+exposure_pred_ref) * (year >= 2011)
	gen EP3_post11 = ln(1+exposure_grade) * (year >= 2011)


	forvalues i = 1/5 {
		gen EPHerf`i'_post11 = ln(1+exposure_Herf`i'*(year >= 2011))
	}

	// Quantiles
	astile tercile = exposure if exposure != 0, nq(3) by(ZE2010)
	replace tercile = 1 if exposure == 0
	forvalues year = 2004/2019 {
		gen HEmid_`year' = (tercile == 2) * (year == `year')
		gen HEtop_`year' = (tercile == 3)  * (year == `year')
	}
	gen HEmid_post11 = (tercile == 2) * (year >= 2011)
	gen HEtop_post11 = (tercile == 3)  * (year >= 2011)
	drop *_${NORMYEAR} tercile


save "${tmp}/regfile", replace
	
	
